



//--------------
// tweaks
//--------------
	float4 ViewVec;
	float3 ScreenColor={1.0f,1.0f,1.0f}; 
	float MotionBlur=1.0f;
	float FinalBlurOffset=1;

//--------------
// Textures
//--------------
   texture RenderColorTX <string Name = " ";>;
   sampler RenderColor=sampler_state 
      {
	Texture=<RenderColorTX>;
   	ADDRESSU=CLAMP;
   	ADDRESSV=CLAMP;
   	ADDRESSW=CLAMP;   	
  	MagFilter=linear;
	MinFilter=linear;
	MipFilter=None;
      };
   texture BlurColorTX <string Name=" ";>;
   sampler BlurColor=sampler_state 
      {
	Texture=<BlurColorTX>;
   	ADDRESSU=CLAMP;
   	ADDRESSV=CLAMP;
   	ADDRESSW=CLAMP;   	
  	MagFilter=linear;
	MinFilter=linear;
	MipFilter=None;
      };
            
//--------------
// structs 
//--------------
   struct InPut
     {
 	float4 Pos:POSITION;
     };
   struct OutPut
     {
	float4 OPos:POSITION; 
 	float2 Tex:TEXCOORD0;
     };

//--------------
// vertex shader
//--------------
   OutPut VS(InPut IN) 
     {
 	OutPut OUT;
	OUT.OPos=IN.Pos; 
 	OUT.Tex=((float2(IN.Pos.x,-IN.Pos.y)+1.0)*0.5)+ViewVec.xy;
	return OUT;
    }

//--------------
// pixel shader
//--------------
   float4 PS(OutPut IN) : COLOR
     {
	float3 Scene=tex2D(RenderColor,IN.Tex);
	return float4(Scene,1);
     }
   float4 PS_Dof(OutPut IN) : COLOR
     {
	float3 Scene=tex2D(RenderColor,IN.Tex);
	
	float Depth=1;

	float3 Blur=tex2D(BlurColor,IN.Tex+float2(ViewVec.x,ViewVec.y)*FinalBlurOffset);
	Blur+=tex2D(BlurColor,IN.Tex+float2(-ViewVec.x,-ViewVec.y)*FinalBlurOffset);
	Blur+=tex2D(BlurColor,IN.Tex+float2(ViewVec.x,-ViewVec.y)*FinalBlurOffset);
	Blur+=tex2D(BlurColor,IN.Tex+float2(-ViewVec.x,ViewVec.y)*FinalBlurOffset);
	Blur*=0.25;

 	Scene=tex2Dlod(RenderColor,float4(IN.Tex.xy,0,0));

	return float4(lerp(Scene,Blur,Depth),1);		
}


//--------------
// techniques   
//--------------
    technique Frame
      {
 	pass p1
      {		
 	VertexShader = compile vs_3_0 VS(); 
 	PixelShader  = compile ps_3_0 PS();
	AlphaBlendEnable=true;
	SrcBlend=SRCALPHA;
	DestBlend=INVSRCALPHA;  	
      }
      }
    technique Dof
      {
 	pass p1
      {		
 	VertexShader = compile vs_3_0 VS(); 
 	PixelShader  = compile ps_3_0 PS_Dof(); 
	AlphaBlendEnable=true;
	SrcBlend=SRCALPHA;
	DestBlend=INVSRCALPHA; 	
      }
      }